"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/* eslint-disable @kbn/eslint/require-license-header */
/**
 *    Copyright 2016 floragunn GmbH

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/**
 * Represents a Search Guard user
 */
class User {
  /**
   * @property {string} username - The username.
   */
  get username() {
    return this._username;
  }

  /**
   * @property {Array} roles - The user roles.
   */
  get roles() {
    return this._roles;
  }

  /**
   * @property {Array} roles - The users unmapped backend roles.
   */
  get backendroles() {
    return this._backendroles;
  }

  /**
   * @property {Array} tenants - The user tenants.
   */
  get tenants() {
    return this._tenants;
  }

  /**
   * @property {Array} tenants - The user tenants.
   */
  get selectedTenant() {
    return this._selectedTenant;
  }
  /**
   * @property {object} credentials - The credentials that were used to authenticate the user.
   */
  get credentials() {
    return this._credentials;
  }

  /**
   * @property {object} proxyCredentials - User credentials to be used in requests to Elasticsearch performed by either the transport client
   * or the query engine.
   */
  get proxyCredentials() {
    return this._proxyCredentials;
  }
  constructor(username, credentials, proxyCredentials, roles, backendroles, tenants, selectedTenant) {
    this._username = username;
    this._credentials = credentials;
    this._proxyCredentials = proxyCredentials;
    this._roles = roles;
    this._selectedTenant = selectedTenant;
    this._backendroles = backendroles;
    this._tenants = tenants;
  }
}
exports.default = User;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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